#!%perl%

# Command-line script to add data from raw text files to AVSPro 
# Not recommended for novices; for more details, contact sf@termina.com

# File format MUST BE as follows:
# cat1,cat2,..,cat5 arbitrary data

use Socket;
use strict;
use vars qw[%cf %mysql %used $db @cats];
require ("routines.pl");

err("Usage: $0 <type> <datafile>   - where <type> is 'sitenames', 'headers', 'descr', 'paragraphs', 'keywords', 'domains'") if $#ARGV < 1;
my ($type, $datafile) = @ARGV;
err("Invalid type: $type") if !grep(/^$type$/, ("sitenames", "headers", "descr", "paragraphs", "keywords", "domains"));

open (F, "< $datafile") or err("Could not open file '$datafile'");

my $count = 0;
while (<F>) {
	/^([\w,]+)\s+(.+)$/ or next;
	my ($cat, $dat) = ($1, $2);
	err("Only 1 category can be specified")
		if ($type eq "sitenames" or $type eq "headers")
		and ($cat =~ /,/);
	$dat =~ s/"/\\"/g;
	$cat =~ tr/,/ /;
	if ($type ne "domains") {
		dosql(qq[insert into ap_$type values("$dat", "$cat")]);
	} else {
		my ($domain, $path) = split(/ /, $dat);
		dosql(qq[insert into ap_domains values("$domain", "$cat", "$path")]);
	}
	$count++;
}

close F;
print "All done; $count items processed.\n";

sub	err {
	my $err = shift;
	wrn ($err, "ERROR");
	exit;
}

sub	wrn {
	my $err = shift(@_)."\n";
	my $warn = shift(@_) || "WARNING";
	$err	=~ s/((.{1,70})(\s+))(?!\n)/$2\n    /g;		# wordwrap
	$err	=~ s/\n(?!    )/\n    /g;			# indent
	$err	=~ s/\s+$//;
	print "\n$warn:\n  * $err\n\n";		# report despite -q
}
